#include <Struct.h>

DWORD CALLBACK ByMaterialPreMode(tProcParams* params)
{
  if (!CurrentState.IsLevel(Z3D_LEVEL_FACES))
  {
    params->pApp->GetMainWnd()->MessageBox(
      "You can apply this tool on faces level only.",
      "Can not select",
      MB_OK | MB_ICONINFORMATION);
    return 0;
  }

  if (CurrentState.UndoMaxSteps > 0)  
    Backup(Z3D_BACKUP_FLAGS, "Select by Material", FALSE, params);

  long iMat = 0;
  if (IDOK == params->sysp(
      Z3D_REQUEST_SELECT_MATERIAL,
      NULL,
      "The faces assigned to desired material will be selected.\nPick desired material.",
      &iMat,
      "Select by this material"))
  {//select by material.
    for (long OC = 0; OC < params->Objects->ObjAmount; OC++)
      if (!params->Objects->ObjSet[OC].Hidden() &&
        !params->Objects->ObjSet[OC].Disabled() &&
        params->Objects->ObjSet[OC].Marked())
      for (long FC = 0; FC < params->Objects->ObjSet[OC].FaceTable->FaceAmount; FC++)
        if (!params->Objects->ObjSet[OC].FaceTable->Table[FC].Hidden() &&
          !params->Objects->ObjSet[OC].FaceTable->Table[FC].Disabled() &&
          (params->Objects->ObjSet[OC].FaceTable->Table[FC].Material == iMat))
        {
          params->Objects->ObjSet[OC].FaceTable->Table[FC].Select();
        }
    return Z3D_PLUGRESULT_VIEWSREDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  return 0;
}